<?php

/**
 * SP Engage Integration
 * @author Celenia Software
 */

require_once('modules/Leads/LeadConvert.php');

class SP_LeadConvert extends LeadConvert
{
    public function __construct($leadId)
    {
        parent::__construct($leadId);
    }

    /**
     * Convert lead function override.
     * @param array $modules
     * @param $transferActivitiesAction The type of transfer to perform on lead activities (e.g. copy, move ...)
     * @param $transferActivitiesModules Array of modules to transfer lead activities to
     * @return array
     */
    public function convertLead($modules, $transferActivitiesAction = '', $transferActivitiesModules = array())
    {
        if (isset($this->lead->sp_synctosilverpop) && $this->lead->sp_synctosilverpop == 1)
        {
            $this->lead->sp_convertedon = TimeDate::getInstance()->nowDb();
        }
        return parent::convertLead($modules, $transferActivitiesAction, $transferActivitiesModules);
    }

    /**
     * Set relationships for contacts.
     * @param $moduleDef
     * @return null
     */
    public function setRelationshipsForModulesToContacts($moduleDef)
    {
        parent::setRelationshipsForModulesToContacts($moduleDef);
        $this->contact->sp_engageid = "";
    }
}
