<?php

/**
 * SP Engage Integration
 * @author Celenia Software
 */

require_once('clients/base/api/ModuleApi.php');

class SP_ModuleApi extends ModuleApi
{

    /**
     *
     * @param ServiceBase $serviceBase
     * @param array $args
     * @param string $aclToCheck
     * @param array $options
     * @return SugarBean
     * @throws SugarApiExceptionNotAuthorized
     * @throws SugarApiExceptionNotFound
     */
    protected function loadBean(ServiceBase $serviceBase, array $args, $aclToCheck = 'view', array $options = Array())
    {
        $bean = parent::loadBean($serviceBase, $args, $aclToCheck, $options);

        // Fill non-db custom fields for merged object pointer...
        if (!empty($args['sp_frommerge'])) { $bean->sp_frommerge = $args['sp_frommerge']; }
        if (!empty($args['sp_slaverecs'])) { $bean->sp_slaverecs = $args['sp_slaverecs']; }

        return $bean;
    }
}
