<?php

/**
 * SP Engage Integration - Token Storage
 * @author Celenia Software
 */

class SP_TokenStorage
{
    /** @var string SP Client ID */
    public static $sp_clientId = "0738d71d-05eb-4382-a7ef-d5ab865eab2c";

    /** @var string SP Client Secret */
    public static $sp_clientSecret = "bcbcf568-ed25-488d-9d2d-3ab989e0b509";

    // public static $sp_clientId = '5c9229bf-0bfc-4c28-8029-7e2806944318';
    // public static $sp_clientSecret = '65b0201e-b087-411d-86dc-352fb686f682';

    /**
     * Get the access token from the token storage.
     * @return string|null
     */
    public static function getAccessToken()
    {
        $administration = new Administration();
        $administration->retrieveSettings('sp_tokenstorage');

        if (!isset($administration->settings['sp_tokenstorage_accesstoken']))
        {
            $administration->saveSetting('sp_tokenstorage', 'accesstoken', '');
            $administration->retrieveSettings('sp_tokenstorage');
        }

        $accessToken = $administration->settings['sp_tokenstorage_accesstoken'];
        if (empty($accessToken)) { $accessToken = null; }

        return $accessToken;
    }

    /**
     * Put the access token to the token storage.
     * @param string $accessToken
     */
    public static function putAccessToken($accessToken)
    {
        $administration = new Administration();
        $administration->saveSetting('sp_tokenstorage', 'accesstoken', $accessToken);
    }
}
