<?php

/**
 * SP Engage Integration
 * @author Celenia Software
 */

if (!defined('sugarEntry') || !sugarEntry)
{
    die('Not a valid entry point');
}

require_once('custom/modules/Leads/SP_LeadConvert.php');
require_once('modules/Leads/clients/base/api/LeadConvertApi.php');

class SP_LeadConvertApi extends LeadConvertApi
{
    /**
     * Convert lead function override.
     * @param ServiceBase $api
     * @param array $args
     * @return array
     */
    public function convertLead(ServiceBase $api, array $args)
    {
        $convert = new SP_LeadConvert($args['leadId']);
        $modules = $this->loadModules($api, $convert->getAvailableModules(), $args['modules']);
		
		$transferActivitiesModules =
            empty($args['transfer_activities_modules']) ? array() : $args['transfer_activities_modules'];
        $transferActivitiesAction =
            empty($args['transfer_activities_action']) ? '' : $args['transfer_activities_action'];
			
        $modules = $convert->convertLead($modules, $transferActivitiesAction, $transferActivitiesModules);
        return array( 'modules' => $this->formatBeans($api, $args, $modules) );
    }
}
