<?php

/**
 * SP Engage Integration - General Settings
 * @author Celenia Software
 */

if (!defined('sugarEntry') || !sugarEntry)
{
    die('Not a valid sugar entry point.');
}

require_once('modules/SP_TokenStorage/SP_TokenStorage.php');
require_once('custom/clients/base/api/SP_EngageApi.php');

class SP_GeneralSettingsViewShow extends SugarView
{
    /**
     * The preDisplay method override.
     */
    public function preDisplay()
    {
        // Check if user is admin
        if (!is_admin($GLOBALS['current_user']))
        {
            sugar_die($GLOBALS['app_strings']['ERR_NOT_ADMIN']);
        }
    }

    /**
     * The display method override.
     */
    public function display()
    {
        $administration = new Administration();
        $save = false;
		$emptyEndpoint = "";
		$emptyRefreshToken = "";
		$emptyHost = "";

        $languageFilePath = __DIR__ . "/../language/" . $GLOBALS["current_language"] . ".sp.php";
        if (!sugar_is_file($languageFilePath)) {
            $GLOBALS["log"]->fatal("The language file with key " . $GLOBALS["current_language"] . " does not exists!");
            require_once __DIR__ . "/../language/en_us.sp.php";
        } else {
            require_once __DIR__ . "/../language/" . $GLOBALS["current_language"] . ".sp.php";
        }

        $this->ss->assign("language", $mod_strings);

        // $GLOBALS["log"]->fatal($GLOBALS["current_language"]);
        // $GLOBALS["log"]->fatal($mod_strings);

        if (isset($_POST['sp_generalsettings_endpoint']))
        {
            $administration->saveSetting("sp_generalsettings", "endpoint", $_POST['sp_generalsettings_endpoint']);
            $save = true;
        }

        if (isset($_POST['sp_generalsettings_host']))
        {
            $administration->saveSetting("sp_generalsettings", "host", $_POST['sp_generalsettings_host']);
            $save = true;
        }

        if (isset($_POST['sp_generalsettings_refreshtoken']))
        {
            $administration->saveSetting("sp_generalsettings", "refreshtoken", $_POST['sp_generalsettings_refreshtoken']);
            $save = true;
        }

        if (isset($_POST['sp_generalsettings_listid']))
        {
            $administration->saveSetting("sp_generalsettings", "listid", $_POST['sp_generalsettings_listid']);
            $save = true;
        }

        if (isset($_POST['sp_generalsettings_username']))
        {
            $administration->saveSetting("sp_generalsettings", "username", $_POST['sp_generalsettings_username']);
            $save = true;
        }

        if (isset($_POST['sp_generalsettings_password']))
        {
            $administration->saveSetting("sp_generalsettings", "password", $_POST['sp_generalsettings_password']);
            $save = true;
        }
        
        $administration->retrieveSettings("sp_generalsettings");

        if ($save == true)
        {
            SP_TokenStorage::putAccessToken("");
            
            $accessToken = SP_EngageApi::refreshAccessToken();
            if (strpos($accessToken, "error") != false)
            {
				$this->ss->assign("status_message", $mod_strings["LBL_SP_SETTINGS_NOT_SAVED"]);
				$administration->saveSetting("sp_generalsettings", "endpoint", $emptyEndpoint);
				$administration->saveSetting("sp_generalsettings", "refreshtoken", $emptyRefreshToken);
				$save = true;
            }
            else
            {
                $this->ss->assign("status_message", $mod_strings["LBL_SP_SETTINGS_SAVED"]);
            }
        }

        $this->ss->assign("settings", $administration->settings);
        $this->ss->assign("module", $this->module);

        $this->ss->display("modules/" . $this->module . "/tpls/show.tpl");
    }
}
