<?php

/**
 * The template folders helper class.
 * @author Alexander Logvinenko <alo@celenia.com>
 * @copyright (c) 2016, Celenia Software
 */
class SPTemplateFoldersHelper
{
    /**
     * Private constructor to make class static.
     * @throws Exception
     */
    private function __construct()
    {
        throw new Exception();
    }

    /**
     *
     * @param SP_TemplateFolders $templateFolder
     * @param array $mailingTemplates
     */
    public static function updateRelatedMailingTemplates($templateFolder, $mailingTemplates)
    {
        global $log;
        // $log->fatal("SPTemplateFoldersHelper::updateRelatedMailingTemplates");

        $templateFolder->load_relationship("sp_templatefolders_sp_mailingtemplates");
        $relatedMailingTemplates = $templateFolder->get_linked_beans("sp_templatefolders_sp_mailingtemplates", "SP_MailingTemplates");

        // Remove all related mailing templates...
        foreach ($relatedMailingTemplates as $relatedMailingTemplate) {
            $templateFolder->sp_templatefolders_sp_mailingtemplates->delete($relatedMailingTemplate->id);
        }

        // Add new related mailing tempaltes...
        foreach ($mailingTemplates as $mailingTemplate) {
            $bean  = BeanFactory::getBean("SP_MailingTemplates");
            $query = new SugarQuery();

            $query->from($bean);
            $query->where()->equals("sp_mailingtemplateid", $mailingTemplate["id"]);
            $query->select([ "id", "sp_mailingtemplateid" ]);

            $result = $query->execute();
            if (sizeof($result) != 1)
            {
                $log->fatal("SP: SPTemplateFoldersHelper::updateRelatedMailingTemplates -> Unexpected count of query result!");
                continue;
            }

            $mailingTemplateId = $result[0]["id"];
            $templateFolder->sp_templatefolders_sp_mailingtemplates->add($mailingTemplateId);
        }

        // $templateFolder->save();
    }

    /**
     *
     * @param SP_TemplateFolders $templateFolder
     * @param array $securityRoles
     */
    public static function updateRelatedSecurityRoles($templateFolder, $securityRoles)
    {
        global $log;
        // $log->fatal("SPTemplateFoldersHelper::updateRelatedSecurityRoles");

        $templateFolder->load_relationship("sp_templatefolders_sp_securityroles");
        $relatedSecurityRoles = $templateFolder->get_linked_beans("sp_templatefolders_sp_securityroles", "SP_SecurityRoles");

        // Remove all related security roles...
        foreach ($relatedSecurityRoles as $relatedSecurityRole) {
            $templateFolder->sp_templatefolders_sp_securityroles->delete($relatedSecurityRole->id);
        }

        // Add new related security roles...
        foreach ($securityRoles as $securityRole) {
            $bean  = BeanFactory::getBean("SP_SecurityRoles");
            $query = new SugarQuery();

            $roleId = $securityRole["id"];
            if (isset($securityRole["sp_roleid"])) {
                $roleId = $securityRole["sp_roleid"];
            }

            $query->from($bean);
            $query->select([ "id", "sp_roleid" ]);
            $query->where()->equals("sp_roleid", $roleId);

            $result = $query->execute();
            $role   = null;

            if (sizeof($result) == 0) {
                $role = BeanFactory::newBean("SP_SecurityRoles");
                $role->name      = $securityRole["name"];
                $role->sp_roleid = $securityRole["id"];
                $role->save();
            } else {
                $role = BeanFactory::retrieveBean("SP_SecurityRoles", $result[0]["id"]);
            }

            $templateFolder->sp_templatefolders_sp_securityroles->add($role->id);
        }

        // $templateFolder->save();
    }

    /**
     *
     * @param SP_TemplateFolders $templateFolder
     * @param array $users
     */
    public static function updateRelatedUsers($templateFolder, $users)
    {
        global $log;
        // $log->fatal("SPTemplateFoldersHelper::updateRelatedUsers");

        $templateFolder->load_relationship("sp_templatefolders_users");
        $relatedUsers = $templateFolder->get_linked_beans("sp_templatefolders_users", "Users");

        // Remove all related users...
        foreach ($relatedUsers as $relatedUser) {
            $templateFolder->sp_templatefolders_users->delete($relatedUser->id);
        }

        // Add new related users...
        foreach ($users as $user) {
            $templateFolder->sp_templatefolders_users->add($user["id"]);
        }

        // $templateFolder->save();
    }
}
