({
    extendsFrom: 'BaseIframeField',
    fieldTag: 'iframe',

    initialize: function(options) {
        this._super('initialize', [ options ]);
        if (this.disposed === true) { return; };
        
        this._render();

        var self = this;
        self.loadData();

        this.view.$el.on('show.bs.tab', 'a[href="#sp_contactinsight' + this.view.cid + '"]', function() { self._render(); });
    },

    _dispose: function() {
        this.view.$el.off('show.bs.tab', 'a[href="#sp_contactinsight' + this.view.cid + '"]');
        this._super('_dispose', []);
    },

    loadData: function() {
        var self = this;

        if (self.model.get('sp_synctosilverpop') === false) {
            self._render();
            return;
        }

        app.api.call('read', app.api.buildURL('sp_api', 'getgeneralsettings'), null, {
            success: function(data) {
                var generalSettings = JSON.parse(data);
                app.api.call('read', app.api.buildURL('sp_api', 'getaccesstoken'), null, {
                    success: function(data) {
                        var accessToken = JSON.parse(data);
                        if (accessToken.hasOwnProperty('error')) {
                            
                            self.error = accessToken.error;
                            
                        } else {
                            
                            var insightURL = generalSettings.sp_endpoint + "/mashup/oauth/contact/contactInsight";
                            insightURL += "?sync_id=" + self.model.get('id').toUpperCase();
                            if (self.model.get('sp_engageid') !== '') {
                                insightURL += "&recipientId=" + self.model.get('sp_engageid');
                            }
                            insightURL += "&listId=" + generalSettings.sp_listid;
                            insightURL += "&access_token=" + accessToken.access_token;

                            self.url = insightURL;
                            self._render();
                        }
                    },
                    error: function(data) {
                        self.error = data;
                        self._render();
                    }
                });
            },
            error: function(data) {
                self.error = data;
                self._render();
            }
        });
    },

    _render: function() {
        this._super('_render', []);
    }

});
