({
    'extendsFrom': "MergeDuplicatesView",

    'initialize': function(options) {
        this._super('initialize', [ options ]);
    },

    '_savePrimary': function() {
        if (this.collection.length > 0) {
            var recs = [];
            _.each(this.collection.models, function(model) {
                recs.push(model.get('id'));
            });
            this.primaryRecord.set({ 'sp_slaverecs': recs });
        }
        this._super('_savePrimary');
    },

    '_renderHtml': function() {
        this.meta = this._generateMetadata(this.mergeFields);
        this._super('_renderHtml');

        if (this.collection.length > 0) {
            _.each(this.collection.models, function(model) {
                model.set({ 'sp_frommerge': 'yes' });
            });
        }

        this.rowFields = {};
        _.each(this.fields, function(field) {
            this.rowFields[field.model.id] = this.rowFields[field.model.id] || [];
            this.rowFields[field.model.id].push(field);
        }, this);

        this.setPrimaryEditable(this.primaryRecord.id);
        this.setDraggable();
    }
});
