<?php

/**
 * Acoustic Campaign Integration
 * @author Enavate
 */

$manifest       = [
    "built_in_version"          => "7.7.1.0",
    "acceptable_sugar_versions" => [ "7.*", "8.*","9.*","10.*","11.*"],
    "acceptable_sugar_flavors"  => [ "ENT", "ULT", "PRO" ],
    "readme"                    => "",
    "key"                       => "SP",
    "author"                    => "ENAVATE",
    "description"               => "This package provides functionality to integrate SugarCRM with the Acoustic Campaign",
    "is_uninstallable"          => true,
    "name"                      => "Acoustic Campaign Integration",
    "published_date"            => "2016-07-11 12:00:00",
    "type"                      => "module",
    "version"                   => 2071,
    "remove_tables"             => "prompt"
];

$installdefs    = [
    "id"                => "SPEngageIntegration",
    "beans"             => [
        [
            "module"    => "SP_DeletedObjectPointer",
            "class"     => "SP_DeletedObjectPointer",
            "path"      => "modules/SP_DeletedObjectPointer/SP_DeletedObjectPointer.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_MergedObjectPointer",
            "class"     => "SP_MergedObjectPointer",
            "path"      => "modules/SP_MergedObjectPointer/SP_MergedObjectPointer.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_engagemailing",
            "class"     => "SP_engagemailing",
            "path"      => "modules/SP_engagemailing/SP_engagemailing.php",
            "tab"       => true
        ], 
        /*
        [
            "module"    => "SP_MailingHistory",
            "class"     => "SP_MailingHistory",
            "path"      => "modules/SP_MailingHistory/SP_MailingHistory.php",
            "tab"       => false
        ],
        */
        [
            "module"    => "SP_Campaign",
            "class"     => "SP_Campaign",
            "path"      => "modules/SP_Campaign/SP_Campaign.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_CampaignMember",
            "class"     => "SP_CampaignMember",
            "path"      => "modules/SP_CampaignMember/SP_CampaignMember.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_SecurityRoles",
            "class"     => "SP_SecurityRoles",
            "path"      => "modules/SP_SecurityRoles/SP_SecurityRoles.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_MailingTemplates",
            "class"     => "SP_MailingTemplates",
            "path"      => "modules/SP_MailingTemplates/SP_MailingTemplates.php",
            "tab"       => true
        ],
        [
            "module"    => "SP_TemplateFolders",
            "class"     => "SP_TemplateFolders",
            "path"      => "modules/SP_TemplateFolders/SP_TemplateFolders.php",
            "tab"       => true
        ],

        array(
            'module' => 'SP_GeneralSettings',
            'class' => 'SP_GeneralSettings',
            'path' => 'modules/SP_GeneralSettings/SP_GeneralSettings.php',
            'tab' => false
        )

    ],
    "layoutdefs"        => [
        /*
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/layoutdefs/sp_mailinghistory_contacts_Contacts.php",
            "to_module" => "Contacts"
        ],
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/layoutdefs/sp_mailinghistory_leads_Leads.php",
            "to_module" => "Leads"
        ],*/
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/layoutdefs/sp_campaign_sp_campaignmember_SP_Campaign.php",
            "to_module" => "SP_Campaign"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_sp_mailingtemplates_SP_MailingTemplates.php",
            "to_module" => "SP_MailingTemplates"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_sp_mailingtemplates_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_sp_securityroles_SP_SecurityRoles.php",
            "to_module" => "SP_SecurityRoles"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_sp_securityroles_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_users_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/layoutdefs/sp_templatefolders_users_Users.php",
            "to_module" => "Users"
        ]
    ],
    "relationships"     => [
        /*
        [
          "meta_data"   => "<basepath>/modules/SP_MailingHistory/relationships/relationships/sp_mailinghistory_contactsMetaData.php"
        ],
        [
          "meta_data"   => "<basepath>/modules/SP_MailingHistory/relationships/relationships/sp_mailinghistory_leadsMetaData.php"
        ],
        */
        [
            "meta_data" => "<basepath>/modules/SP_Campaign/relationships/relationships/sp_campaign_sp_campaignmemberMetaData.php",
        ],
        [
            "meta_data" => "<basepath>/modules/SP_Campaign/relationships/relationships/sp_campaign_campaignsMetaData.php",
        ],
        [
            "meta_data" => "<basepath>/modules/SP_TemplateFolders/relationships/relationships/sp_templatefolders_sp_mailingtemplatesMetaData.php"
        ],
        [
            "meta_data" => "<basepath>/modules/SP_TemplateFolders/relationships/relationships/sp_templatefolders_sp_securityrolesMetaData.php"
        ],
        [
            "meta_data" => "<basepath>/modules/SP_TemplateFolders/relationships/relationships/sp_templatefolders_usersMetaData.php"
        ]
    ],
    "sidecar"           => [
        /*
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/clients/base/layouts/subpanels/sp_mailinghistory_contacts_Contacts.php",
            "to_module" => "Contacts"
        ],
        [
          "from"        => "<basepath>/modules/SP_MailingHistory/clients/base/layouts/subpanels/sp_mailinghistory_leads_Leads.php",
          "to_module"   => "Leads"
        ],
        */
        [
            "from"      => "<basepath>/modules/SP_Campaign/clients/base/layouts/subpanels/sp_campaign_sp_campaignmember_SP_Campaign.php",
            "to_module" => "SP_Campaign"
        ],
        [
          "from"        => "<basepath>/modules/SP_Campaign/clients/mobile/layouts/subpanels/sp_campaign_sp_campaignmember_SP_Campaign.php",
          "to_module"   => "SP_Campaign"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/base/layouts/subpanels/sp_templatefolders_sp_mailingtemplates_SP_MailingTemplates.php",
            "to_module"   => "SP_MailingTemplates"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/base/layouts/subpanels/sp_templatefolders_sp_mailingtemplates_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/base/layouts/subpanels/sp_templatefolders_sp_securityroles_SP_SecurityRoles.php",
            "to_module"   => "SP_SecurityRoles"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/base/layouts/subpanels/sp_templatefolders_sp_securityroles_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/base/layouts/subpanels/sp_templatefolders_users_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/mobile/layouts/subpanels/sp_templatefolders_sp_mailingtemplates_SP_MailingTemplates.php",
            "to_module"   => "SP_MailingTemplates"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/mobile/layouts/subpanels/sp_templatefolders_sp_mailingtemplates_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/mobile/layouts/subpanels/sp_templatefolders_sp_securityroles_SP_SecurityRoles.php",
            "to_module"   => "SP_SecurityRoles"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/mobile/layouts/subpanels/sp_templatefolders_sp_securityroles_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ],
        [
            "from"        => "<basepath>/modules/SP_TemplateFolders/clients/mobile/layouts/subpanels/sp_templatefolders_users_SP_TemplateFolders.php",
            "to_module"   => "SP_TemplateFolders"
        ]
    ],
    "vardefs"           => [
        /*
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/vardefs/sp_mailinghistory_contacts_Contacts.php",
            "to_module" => "Contacts"
        ],
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/vardefs/sp_mailinghistory_leads_Leads.php",
            "to_module" => "Leads"
        ],
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/vardefs/sp_mailinghistory_contacts_SP_MailingHistory.php",
            "to_module" => "SP_MailingHistory"
        ],
        [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/vardefs/sp_mailinghistory_leads_SP_MailingHistory.php",
            "to_module" => "SP_MailingHistory"
        ],
        */
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/vardefs/sp_campaign_sp_campaignmember_SP_Campaign.php",
            "to_module" => "SP_Campaign"
        ],
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/vardefs/sp_campaign_sp_campaignmember_SP_CampaignMember.php",
            "to_module" => "SP_CampaignMember"
        ],
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/vardefs/sp_campaign_campaigns_Campaigns.php",
            "to_module" => "Campaigns"
        ],
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/vardefs/sp_campaign_campaigns_SP_Campaign.php",
            "to_module" => "SP_Campaign"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_sp_mailingtemplates_SP_MailingTemplates.php",
            "to_module" => "SP_MailingTemplates"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_sp_mailingtemplates_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_sp_securityroles_SP_SecurityRoles.php",
            "to_module" => "SP_SecurityRoles"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_sp_securityroles_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_users_SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/vardefs/sp_templatefolders_users_Users.php",
            "to_module" => "Users"
        ]
    ],
    "layoutfields"        => [
        [
            "additional_fields" => [
                "Campaigns" => "sp_campaign_campaigns_name",
            ]
        ]
    ],
    "image_dir"         => "<basepath>/icons",
    "copy"              => [
        0 => [
            "from"      => "<basepath>/modules",
            "to"        => "modules"
        ],
        1 => [
            "from"      => "<basepath>/custom",
            "to"        => "custom"
        ]
    ],
    "language"          => [
        [
            "from"      => "<basepath>/language/application/en_us.sp.php",
            "to"        => "application"
        ],
       /* 1 => [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/language/SP_MailingHistory.php",
            "to_module" => "SP_MailingHistory",
            "language"     => "en_us"
        ],
        2 => [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/language/Contacts.php",
            "to_module" => "Contacts",
            "language"     => "en_us"
        ],
        3 => [
            "from"      => "<basepath>/modules/SP_MailingHistory/relationships/language/Leads.php",
            "to_module" => "Leads",
            "language"     => "en_us"
        ],*/
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/language/SP_Campaign.php",
            "to_module" => "SP_Campaign",
            "language"  => "en_us",
        ],
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/language/SP_CampaignMember.php",
            "to_module" => "SP_CampaignMember",
            "language"  => "en_us",
        ],
        [
            "from"      => "<basepath>/modules/SP_Campaign/relationships/language/Campaigns.php",
            "to_module" => "Campaigns",
            "language"  => "en_us",
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/language/SP_MailingTemplates.php",
            "to_module" => "SP_MailingTemplates",
            "language"  => "en_us"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/language/SP_SecurityRoles.php",
            "to_module" => "SP_SecurityRoles",
            "language"  => "en_us"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/language/SP_TemplateFolders.php",
            "to_module" => "SP_TemplateFolders",
            "language"  => "en_us"
        ],
        [
            "from"      => "<basepath>/modules/SP_TemplateFolders/relationships/language/Users.php",
            "to_module" => "Users",
            "language"  => "en_us"
        ]
    ]
];
