<?php

/**
 * SP General Settings class.
 * @author Celenia Software
 * @version 1.0.0.0
 */
class SP_GeneralSettings extends Basic {
    public $new_schema = true;
    public $module_dir = 'SP_GeneralSettings';
    public $object_name = 'SP_GeneralSettings';
    public $table_name = 'SP_GeneralSettings';
    public $importable = false;
    public $team_id;
    public $team_set_id;
    public $team_count;
    public $team_name;
    public $team_link;
    public $team_count_link;
    public $teams;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $doc_owner;
    public $user_favorites;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $activities;
    public $following;
    public $following_link;
    public $my_favorite;
    public $favorite_link;
    
    /** @var string The endpoint */
    public $sp_endpoint;

    /** @var string The host */
    public $sp_host;

    /** @var string The refresh token */
    public $sp_refreshtoken;

    /** @var string The list id */
    public $sp_listid;

    /** @var string The integration user login name */
    public $sp_username;

    /** @var string The integration user password */
    public $sp_password;

    /**
     * Retrieve the general settings.
     */
    public function retrieve($id = -1, $encode = true, $deleted = true)
    {
        $administration = new Administration();
        $administration->retrieveSettings("sp_generalsettings");
        
        $this->retrieveEndpoint($administration);
        $this->retrieveHost($administration);
        $this->retrieveRefreshToken($administration);
        $this->retrieveListId($administration);
        $this->retrieveUsername($administration);
        $this->retrievePassword($administration);
    }
    
    public function toJson()
    {
        return json_encode([
            "sp_endpoint"       => $this->sp_endpoint,
            "sp_host"           => $this->sp_host,
            "sp_refreshtoken"   => $this->sp_refreshtoken,
            "sp_listid"         => $this->sp_listid,
            "sp_username"       => $this->sp_username,
            "sp_password"       => $this->sp_password
        ]);
    }
    /**
     * 
     * @param Administration $administration
     */
    private function retrieveEndpoint($administration)
    {
        if (isset($administration->settings['sp_generalsettings_endpoint']))
        {
            $this->sp_endpoint = $administration->settings['sp_generalsettings_endpoint'];
            if (empty($this->sp_endpoint)) { $this->sp_endpoint = null; }
            
            if (substr(strtolower($this->sp_endpoint), 0, 4) !== "http")
                $this->sp_endpoint = "https://" . $this->sp_endpoint;
        }
    }
    
    /**
     * 
     * @param Administration $administration
     */
    private function retrieveHost($administration)
    {
        if (isset($administration->settings['sp_generalsettings_host']))
        {
            $this->sp_host = $administration->settings['sp_generalsettings_host'];
            if (empty($this->sp_host)) { $this->sp_host = null; }
            
            if (substr(strtolower($this->sp_host), 0, 4) !== "http")
                $this->sp_host = "https://" . $this->sp_host;
        }
    }
    
    /**
     * 
     * @param Administration $administration
     */
    private function retrieveRefreshToken($administration)
    {
        if (isset($administration->settings['sp_generalsettings_refreshtoken']))
        {
            $this->sp_refreshtoken = $administration->settings['sp_generalsettings_refreshtoken'];
            if (empty($this->sp_refreshtoken)) { $this->sp_refreshtoken = null; }
        }
    }
    
    /**
     * 
     * @param Administration $administration
     */
    private function retrieveListId($administration)
    {
        if (isset($administration->settings['sp_generalsettings_listid']))
        {
            $this->sp_listid = $administration->settings['sp_generalsettings_listid'];
            if (empty($this->sp_listid)) { $this->sp_listid = null; }
        }
    }
    
    /**
     * 
     * @param Administration $administration
     */
    private function retrieveUsername($administration)
    {
        if (isset($administration->settings['sp_generalsettings_username']))
        {
            $this->sp_username = $administration->settings['sp_generalsettings_username'];
            if (empty($this->sp_username)) { $this->sp_username = null; }
        }
    }
    
    /**
     * 
     * @param Administration $administration
     */
    private function retrievePassword($administration)
    {
        if (isset($administration->settings['sp_generalsettings_password']))
        {
            $this->sp_password = $administration->settings['sp_generalsettings_password'];
            if (empty($this->sp_password)) { $this->sp_password = null; }
        }
    }

    public function bean_implements($interface){
        return false;
    }
}
